/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class IntProperty
extends TeamProperty<Integer> {
    public final int minValue;
    public final int maxValue;

    public IntProperty(ResourceLocation id, int def, int min, int max) {
        super(id, def);
        this.minValue = min;
        this.maxValue = max;
    }

    public IntProperty(ResourceLocation id, int def) {
        this(id, def, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntProperty(ResourceLocation id, PacketBuffer buf) {
        super(id, buf.func_150792_a());
        this.minValue = buf.func_150792_a();
        this.maxValue = buf.func_150792_a();
    }

    @Override
    public TeamPropertyType<Integer> getType() {
        return TeamPropertyType.INT;
    }

    @Override
    public Optional<Integer> fromString(String string) {
        try {
            int num = Integer.parseInt(string);
            return Optional.of(MathHelper.func_76125_a((int)num, (int)this.minValue, (int)this.maxValue));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150787_b(((Integer)this.defaultValue).intValue());
        buf.func_150787_b(this.minValue);
        buf.func_150787_b(this.maxValue);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Integer> value) {
        config.addInt(this.id.func_110624_b() + "." + this.id.func_110623_a(), ((Integer)value.value).intValue(), value.consumer, ((Integer)this.defaultValue).intValue(), this.minValue, this.maxValue);
    }

    @Override
    public INBT toNBT(Integer value) {
        return IntNBT.func_229692_a_((int)value);
    }

    @Override
    public Optional<Integer> fromNBT(INBT tag) {
        if (tag instanceof NumberNBT) {
            return Optional.of(MathHelper.func_76125_a((int)((NumberNBT)tag).func_150287_d(), (int)this.minValue, (int)this.maxValue));
        }
        return Optional.empty();
    }
}

